/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.village;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.betterx.bclib.api.v2.levelgen.structures.SingleEndPoolElement;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePools;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndProcessors;

public class VillagePools {
    public static final ResourceKey<PlacedFeature> CHORUS_VILLAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)BetterEnd.makeID("village_chorus"));
    public static ResourceKey<StructureTemplatePool> TERMINATORS_KEY = StructurePools.createKey((ResourceLocation)BetterEnd.makeID("village/terminators"));
    public static ResourceKey<StructureTemplatePool> START = StructurePools.createKey((ResourceLocation)BetterEnd.makeID("village/center_piece"));
    public static ResourceKey<StructureTemplatePool> HOUSES_KEY = StructurePools.createKey((ResourceLocation)BetterEnd.makeID("village/houses"));
    public static ResourceKey<StructureTemplatePool> STREET_KEY = StructurePools.createKey((ResourceLocation)BetterEnd.makeID("village/streets"));
    public static ResourceKey<StructureTemplatePool> STREET_DECO_KEY = StructurePools.createKey((ResourceLocation)BetterEnd.makeID("village/street_decorations"));
    public static ResourceKey<StructureTemplatePool> DECORATIONS_KEY = StructurePools.createKey((ResourceLocation)BetterEnd.makeID("village/decorations"));

    public static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> single(String name, Holder<StructureProcessorList> processor, int weight) {
        return Pair.of((Object)SingleEndPoolElement.end((ResourceLocation)BetterEnd.makeID(name), processor), (Object)weight);
    }

    public static void bootstrap(BootstapContext<StructureTemplatePool> ctx) {
        HolderGetter processorGetter = ctx.m_255420_(Registries.f_257011_);
        HolderGetter featureGetter = ctx.m_255420_(Registries.f_256988_);
        HolderGetter poolGetter = ctx.m_255420_(Registries.f_256948_);
        HolderGetter biomeGetter = ctx.m_255420_(Registries.f_256952_);
        Holder.Reference emptyPool = poolGetter.m_255043_(Pools.f_127186_);
        Holder.Reference terminatorPool = poolGetter.m_255043_(TERMINATORS_KEY);
        Holder.Reference mossifyProcessor = processorGetter.m_255043_(EndProcessors.WEATHERED_10_PERCENT);
        Holder.Reference crack = processorGetter.m_255043_(EndProcessors.CRACK_20_PERCENT);
        Holder.Reference cry = processorGetter.m_255043_(EndProcessors.CRYING_10_PERCENT);
        Holder.Reference crackAndWeather = processorGetter.m_255043_(EndProcessors.CRACK_AND_WEATHER);
        Holder.Reference endStreetProcessor = processorGetter.m_255043_(EndProcessors.END_STREET);
        Holder.Reference emptyProcessor = processorGetter.m_255043_(ProcessorLists.f_127198_);
        Holder.Reference chorus = featureGetter.m_255043_(CHORUS_VILLAGE);
        ctx.m_255272_(TERMINATORS_KEY, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of(VillagePools.single("village/terminators/stree_terminator_01", (Holder<StructureProcessorList>)emptyProcessor, 1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        ctx.m_255272_(START, (Object)new StructureTemplatePool((Holder)terminatorPool, (List)ImmutableList.of(VillagePools.single("village/center/light_pyramid_01", (Holder<StructureProcessorList>)emptyProcessor, 2), VillagePools.single("village/center/light_pyramid_02", (Holder<StructureProcessorList>)emptyProcessor, 1)), StructureTemplatePool.Projection.RIGID));
        ctx.m_255272_(HOUSES_KEY, (Object)new StructureTemplatePool((Holder)terminatorPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210541_(), (Object)5), VillagePools.single("village/houses/small_house_01", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_02", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_03", (Holder<StructureProcessorList>)emptyProcessor, 2), VillagePools.single("village/houses/small_house_04", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_05", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_06", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_07", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_08", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_09", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_10", (Holder<StructureProcessorList>)emptyProcessor, 2), VillagePools.single("village/houses/small_house_11", (Holder<StructureProcessorList>)emptyProcessor, 1), (Object[])new Pair[]{VillagePools.single("village/houses/small_house_12", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_13", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_14", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_15", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/houses/small_house_16", (Holder<StructureProcessorList>)emptyProcessor, 2), VillagePools.single("village/houses/small_house_17", (Holder<StructureProcessorList>)crackAndWeather, 4), VillagePools.single("village/houses/animal_pen_01", (Holder<StructureProcessorList>)emptyProcessor, 3), VillagePools.single("village/decoration/stable_01", (Holder<StructureProcessorList>)crack, 2), VillagePools.single("village/decoration/pond_01", (Holder<StructureProcessorList>)mossifyProcessor, 1), VillagePools.single("village/decoration/respawn_01", (Holder<StructureProcessorList>)endStreetProcessor, 1), VillagePools.single("village/decoration/respawn_02", (Holder<StructureProcessorList>)endStreetProcessor, 1), VillagePools.single("village/decoration/fountain_01", (Holder<StructureProcessorList>)endStreetProcessor, 1), VillagePools.single("village/street_decoration/work_01", (Holder<StructureProcessorList>)endStreetProcessor, 1)}), StructureTemplatePool.Projection.RIGID));
        ctx.m_255272_(STREET_KEY, (Object)new StructureTemplatePool((Holder)terminatorPool, (List)ImmutableList.of(VillagePools.single("village/streets/street_01", (Holder<StructureProcessorList>)endStreetProcessor, 6), VillagePools.single("village/streets/street_02", (Holder<StructureProcessorList>)endStreetProcessor, 5), VillagePools.single("village/streets/street_03", (Holder<StructureProcessorList>)endStreetProcessor, 7), VillagePools.single("village/streets/street_04", (Holder<StructureProcessorList>)endStreetProcessor, 6), VillagePools.single("village/streets/curve_01", (Holder<StructureProcessorList>)endStreetProcessor, 8), VillagePools.single("village/streets/curve_02", (Holder<StructureProcessorList>)endStreetProcessor, 8), VillagePools.single("village/streets/t_crossing_01", (Holder<StructureProcessorList>)endStreetProcessor, 4), VillagePools.single("village/streets/t_crossing_02", (Holder<StructureProcessorList>)endStreetProcessor, 4)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        ctx.m_255272_(STREET_DECO_KEY, (Object)new StructureTemplatePool((Holder)terminatorPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210541_(), (Object)5), VillagePools.single("village/street_decoration/lamp_02", (Holder<StructureProcessorList>)emptyProcessor, 4), VillagePools.single("village/street_decoration/lamp_05", (Holder<StructureProcessorList>)emptyProcessor, 2), VillagePools.single("village/street_decoration/lamp_06", (Holder<StructureProcessorList>)emptyProcessor, 3), VillagePools.single("village/street_decoration/obsidian_01", (Holder<StructureProcessorList>)cry, 2), VillagePools.single("village/street_decoration/obsidian_02", (Holder<StructureProcessorList>)cry, 3), VillagePools.single("village/street_decoration/obsidian_03", (Holder<StructureProcessorList>)cry, 2), VillagePools.single("village/street_decoration/obsidian_04", (Holder<StructureProcessorList>)cry, 2), VillagePools.single("village/street_decoration/obsidian_05", (Holder<StructureProcessorList>)cry, 1), (Object)Pair.of((Object)StructurePoolElement.m_210502_((Holder)chorus), (Object)2)), StructureTemplatePool.Projection.RIGID));
        ctx.m_255272_(DECORATIONS_KEY, (Object)new StructureTemplatePool((Holder)terminatorPool, (List)ImmutableList.of(), StructureTemplatePool.Projection.RIGID));
    }
}

